import matplotlib.pyplot as plt


R_values = [1, 3, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60]
# OUR method 
our_method_case1_loss = [0.3254, 0.2487, 0.2358, 0.2270, 0.2245, 0.2234, 0.2228, 0.2225, 0.2226, 0.2222, 0.2223, 0.2222, 0.2225, 0.2222]
our_method_case1_acc = [0.8257, 0.8444, 0.8538, 0.8658, 0.8695, 0.8724, 0.8729, 0.8747, 0.8739, 0.8754, 0.8744, 0.8757, 0.8748, 0.8757]

our_method_case2_loss = [0.3783, 0.2729, 0.2524, 0.2364, 0.2307, 0.2279, 0.2264, 0.2256, 0.2247, 0.2240, 0.2236, 0.2235, 0.2233, 0.2235]
our_method_case2_acc = [0.8128, 0.8273, 0.84, 0.8526, 0.86, 0.8639, 0.8659, 0.8675, 0.8689, 0.8696, 0.8708, 0.8723, 0.8712, 0.8719]

# FedProx 
fedprox_case1_loss = [0.3998, 0.3188, 0.2778, 0.2482, 0.2386, 0.2341, 0.2307, 0.2288, 0.2274, 0.2267, 0.2259, 0.2253, 0.2246, 0.2245]
fedprox_case1_acc = [0.8069, 0.8268, 0.835, 0.8428, 0.852, 0.8567, 0.8595, 0.8636, 0.8665, 0.868, 0.8669, 0.8697, 0.8704, 0.8694]

fedprox_case2_loss = [0.4158, 0.3343, 0.2955, 0.2581, 0.2455, 0.2386, 0.2344, 0.2315, 0.2298, 0.2287, 0.2279, 0.2270, 0.2260, 0.2281]
fedprox_case2_acc = [0.7924, 0.8183, 0.8279, 0.839, 0.8432, 0.8528, 0.8564, 0.8593, 0.8608, 0.8642, 0.8663, 0.8682, 0.8694, 0.8637]

# Centralized Learning 
centralized_loss = [0.25496094110329137, 0.23096791330671113, 0.226340581386002, 0.22331472244387962, 0.22291099494858208, 0.22271373508113237, 
                    0.22261866750316053, 0.22332661546800509, 0.22257698435403128, 0.22227190481940864, 0.2242757717450323, 0.2225041104484675, 
                    0.22240288007667255, 0.22270177005901365]
centralized_acc = [0.8394, 0.8588, 0.8678, 0.8747, 0.8742, 0.8763, 0.8754, 0.879, 0.8758, 0.8768, 0.8736, 0.8762, 0.8774, 0.8761]

# FedAvg  (Case 1)
fedavg_case1_loss = [0.3981193075734737, 0.31745688073866835, 0.2877822775960598, 0.25725415578184485, 0.24550531158540073, 0.23850086026491146, 
                     0.23448533871542154, 0.231878383496806, 0.23037047159951332, 0.2291201987903768, 0.2279058013268204, 0.2272510481663501, 
                     0.2263860918661198, 0.22636366194875657]
fedavg_case1_acc = [0.8014, 0.8252, 0.8292, 0.8392, 0.845, 0.8529, 0.8554, 0.8594, 0.8593, 0.8632, 0.865, 0.8654, 0.8677, 0.8669]

# FedAvg  (Case 2)
fedavg_case2_loss = [0.41577073534495823, 0.3336205822076038, 0.2951836116373724, 0.25797332389389915, 0.2473965076509697, 0.24075580075893968, 
                     0.2363633974027507, 0.23322822699472592, 0.23115516820427484, 0.22959486002150178, 0.2283972742633058, 0.2275364784680453, 
                     0.22671148480008485, 0.22590008580401036]
fedavg_case2_acc = [0.7924, 0.818, 0.8283, 0.839, 0.8414, 0.8482, 0.8535, 0.8569, 0.8598, 0.8608, 0.8637, 0.8662, 0.8671, 0.8687]


label_fontsize = 30
tick_fontsize = 25
legend_fontsize = 25


plt.rcParams['font.family'] = 'Times New Roman'  #

#  Loss 
plt.figure(figsize=(10, 6))
plt.plot(R_values, our_method_case1_loss, label='Our method - Case 1', marker='o', color='blue')
plt.plot(R_values, our_method_case2_loss, label='Our method - Case 2', marker='o', color='blue', linestyle='dashed')
plt.plot(R_values, fedprox_case1_loss, label='FedProx - Case 1', marker='s', color='green')
plt.plot(R_values, fedprox_case2_loss, label='FedProx - Case 2', marker='s', color='green', linestyle='dashed')
plt.plot(R_values, centralized_loss, label='Centralized Learning', marker='^', color='red')
plt.plot(R_values, fedavg_case1_loss, label='FedAvg - Case 1', marker='*', color='purple')
plt.plot(R_values, fedavg_case2_loss, label='FedAvg - Case 2', marker='*', color='purple', linestyle='dashed')

plt.xlabel('Total Resource R (Seconds)', fontsize=label_fontsize)
plt.ylabel('Loss Value', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)
plt.tight_layout()

#  Loss 
plt.savefig('loss_plot_resource.png', dpi=300, bbox_inches='tight')
plt.savefig('loss_plot_resource.svg', format='svg', bbox_inches='tight')
plt.savefig('loss_plot_resource.pdf', format='pdf', bbox_inches='tight')
plt.show()

# Accuracy 
plt.figure(figsize=(10, 6))
plt.plot(R_values, our_method_case1_acc, label='Our method - Case 1', marker='o', color='blue')
plt.plot(R_values, our_method_case2_acc, label='Our method - Case 2', marker='o', color='blue', linestyle='dashed')
plt.plot(R_values, fedprox_case1_acc, label='FedProx - Case 1', marker='s', color='green')
plt.plot(R_values, fedprox_case2_acc, label='FedProx - Case 2', marker='s', color='green', linestyle='dashed')
plt.plot(R_values, centralized_acc, label='Centralized Learning', marker='^', color='red')
plt.plot(R_values, fedavg_case1_acc, label='FedAvg - Case 1', marker='*', color='purple')
plt.plot(R_values, fedavg_case2_acc, label='FedAvg - Case 2', marker='*', color='purple', linestyle='dashed')

plt.xlabel('Total Resource R (Seconds)', fontsize=label_fontsize)
plt.ylabel('Prediction Accuracy', fontsize=label_fontsize)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=legend_fontsize)
plt.grid(True)
plt.tight_layout()

plt.savefig('accuracy_plot_resource.png', dpi=300, bbox_inches='tight')
plt.savefig('accuracy_plot_resource.svg', format='svg', bbox_inches='tight')
plt.savefig('accuracy_plot_resource.pdf', format='pdf', bbox_inches='tight')
plt.show()
